<x-layout bodyClass="g-sidenav-show  bg-dark-silk">
    <x-navbars.sidebar activePage="users"></x-navbars.sidebar>
    <main class="main-content position-relative max-height-vh-100 h-100 border-radius-lg ">
        <!-- Navbar -->
        <x-navbars.navs.auth titlePage="Alterar Senha"></x-navbars.navs.auth>
        <!-- End Navbar -->
        <div class="container-fluid py-4">
            <div class="row">
                <div class="col-md-12">
                    <form method="post" action="{{ route('user.change.password', [Auth::user()->id, csrf_token()]) }}" autocomplete="off"
                    class="form-horizontal" enctype="multipart/form-data" id="formPrincipal">
                        @csrf
                        @method('put')

                        <meta name="csrf-token" content="{{ csrf_token() }}">
                        <div class="card mb-4">
                            <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                                <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                    <h5 class="mx-3">Alterar Senha</h5>
                                </div>
                            </div>
                            <div class="card-body ">
                            {{-- Messagens da session --}}
                                @include('partials.session-message')
                                @if ($errors->any() || session('error'))
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="alert alert-danger">
                                            <button type="button" class="close" data-dismiss="alert"
                                                    aria-label="Close">
                                                <i class="tim-icons icon-simple-remove"></i>
                                            </button>
                                            <span>{{$errors->any() ? $errors->first() : session('error')}}</span>
                                        </div>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <div class="card-body ">
                                        <div class="row">
                                            <div class="col-md-12 col-lg-12">
                                                <h4 class="mb-3 bg-light">Alterar Senha</h4>
                                            </div>
                                            <div class="col-md-12 col-lg-12">
                                                <div class="row">
                                                    {{-- Senha --}}
                                                    <div class="col-md-6">
                                                        <div class="input-group input-group-static my-3 {{ $errors->has('password') ? ' is-invalid' : '' }}">
                                                            <label for="input-password">{{ __(' Senha') }}</label>
                                                            <input class="form-control"
                                                                input type="password" name="password" id="input-password"
                                                                placeholder="{{ __('Senha') }}"/>
                                                            @if ($errors->has('password'))
                                                                <span id="name-error" class="error text-danger"
                                                                        for="input-name">{{ $errors->first('password') }}</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    {{-- Confirmar Senha --}}
                                                    <div class="col-md-6">
                                                        <div class="input-group input-group-static my-3 {{ $errors->has('password_confirmation') ? ' is-invalid' : '' }}">
                                                                <label for="input-password-confirmation">{{ __('Confirmar senha') }}</label>
                                                                <input class="form-control" name="password_confirmation"
                                                                        id="input-password-confirmation" type="password"
                                                                        placeholder="{{ __('Confirmar senha') }}"/>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="card mb-4">
                                    <div class="card-footer ml-auto mr-auto">
                                        <button id="submit-button" type="submit" class="btn btn-success">Atualizar</button>
                                        <a href="{{ route('admin.users.index') }}"
                                                class="btn btn-light">{{ __('Voltar') }}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </main>
    <x-plugins></x-plugins>
</x-layout>
@push('js')
<script>
$(document).ready(function() {
    $('#submit-button').click(function(event) {
        var password = $('#input-password').val();
        var confirmPassword = $('#input-password-confirmation').val();

        if (password !== confirmPassword) {
            event.preventDefault(); // Impede o envio do formulário
            alert("A senha e a confirmação de senha não correspondem.");
        }
    });
});
</script>
@endpush
{{-- @TODO: criar mascaras --}}
