@php
    $estados = ['AC'=>'Acre','AL'=>'Alagoas','AP'=>'Amapá','AM'=>'Amazonas','BA'=>'Bahia','CE'=>'Ceará','DF'=>'Distrito Federal','ES'=>'Espírito Santo','GO'=>'Goiás','MA'=>'Maranhão','MT'=>'Mato Grosso','MS'=>'Mato Grosso do Sul','MG'=>'Minas Gerais','PA'=>'Pará','PB'=>'Paraíba','PR'=>'Paraná','PE'=>'Pernambuco','PI'=>'Piauí','RJ'=>'Rio de Janeiro','RN'=>'Rio Grande do Norte','RS'=>'Rio Grande do Sul','RO'=>'Rondônia','RR'=>'Roraima','SC'=>'Santa Catarina','SP'=>'São Paulo','SE'=>'Sergipe','TO'=>'Tocantins'];
@endphp

@push('css')
    <style>
        .progress-bar {
            transition: width 0.4s ease;
        }

        .input-group.input-group-outline.is-focused .form-label, .input-group.input-group-outline.is-filled .form-label {
            color: #1461e6;
        }

        .input-group.input-group-outline.is-focused .form-label:before, .input-group.input-group-outline.is-focused .form-label:after, .input-group.input-group-outline.is-filled .form-label:before, .input-group.input-group-outline.is-filled .form-label:after {
            border-top-color: #1461e6;
            box-shadow: inset 0 1px #1461e6;
        }

        .input-group.input-group-outline.is-focused .form-label + .form-control, .input-group.input-group-outline.is-filled .form-label + .form-control {
            border-color: #1461e6 !important;
            border-top-color: transparent !important;
            box-shadow: inset 1px 0 #1461e6, inset -1px 0 #1461e6, inset 0 -1px #1461e6;
        }

        #chave-pix {
            /* Remover a barra de scroll */
            -ms-overflow-style: none;
            scrollbar-width: none;

        }
    </style>
@endpush

<x-layout bodyClass="bg-gray-200">
    <main class="main-content mt-0">
        <section>
            <div class="page-header min-vh-100">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-4 col-lg-5 col-md-7 d-flex flex-column ms-auto me-auto ms-lg-5 me-lg-auto ">
                            <div class="card card-plain bg-white">
                                <div class="card-header">
                                    <h4 class="font-weight-bolder" id="card-title">Dados da Empresa</h4>
                                    <p class="mb-0 text-sm" id="card-subtitle">Informe os dados da sua empresa</p>
                                    <div class="progress-wrapper">
                                        <div class="progress">
                                            <div class="progress-bar bg-gradient-success" role="progressbar" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100" style="width: 25%;" id="progress-bar"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <!-- Form stays on the left side -->
                                    <form role="form" action="{{ route('cadastro.store', ['plano' => $plano]) }}" id="multi-step-form">
                                        <!-- Step 1 -->
                                        <div class="step" id="step1">
                                            @if (isset($pessoa))
                                                <input type="hidden" name="idrepresentante" id="idrepresentante" value="{{ $pessoa->idpessoa }}">
                                                {{-- <span class="p-2 rounded" style="background-color: #90909027">Representante: {{ $pessoa->nome }}</span> --}}
                                            @endif
                                            <div class="input-group input-group-outline mb-3 mt-3" data-input-name='documento'>
                                                <label class="form-label">CNPJ</label>
                                                <input type="text" class="form-control" name="documento" id="documento" inputmode="numeric" minlength="11" maxlength="18" required>
                                            </div>
                                            <div class="input-group input-group-outline mb-3" data-input-name='celular'>
                                                <label class="form-label">Celular/Whatsapp</label>
                                                <input type="text" class="form-control" name="celular" autocomplete="tel" id="celular" inputmode="numeric" minlength="11" maxlength="16" required>
                                            </div>
                                            <div class="text-center col-md-6">
                                                <button type="button" class="btn btn-sm rounded-2 bg-gradient-info w-100 mt-4 mb-0" onclick="consultarCNPJ()">
                                                    <span class="button-text d-flex align-items-center justify-content-between">
                                                        <span class="ms-3">Avançar</span>
                                                        <i class="fa fa-chevron-right fs-6 m-0 p-0" aria-hidden="true"></i>
                                                    </span>
                                                    <div class="spinner-border spinner-border-sm text-light d-none" role="status">
                                                        <span class="visually-hidden">Loading...</span>
                                                    </div>
                                                </button>
                                            </div>
                                        </div>

                                        <!-- Step 2 -->
                                        <div class="step" id="step2" style="display: none;">
                                            <div class="input-group input-group-outline mb-3" data-input-name='nome'>
                                                <label class="form-label">Razão Social</label>
                                                <input type="text" class="form-control" name="nome" id="nome" required>
                                            </div>
                                            <input data-input-name="nomefantasia" type="hidden" name="nomefantasia" id="nomefantasia">
                                            <div class="input-group input-group-outline mb-3" data-input-name='email'>
                                                <label class="form-label">E-mail</label>
                                                <input type="email" class="form-control" name="email" id="email" autocomplete="email" required>
                                            </div>
                                            <div class="input-group input-group-outline mb-3" data-input-name='senha'>
                                                <label class="form-label">Crie sua senha</label>
                                                <input type="password" class="form-control" name="password" id="senha" autocomplete="new-password" required>
                                            </div>
                                            <div class="row space-y-4">
                                                <div class="col-md-6">
                                                    <button type="button" class="btn btn-sm rounded-2 bg-outline-primary border border-1 w-100 mt-4 mb-0 d-flex align-items-center justify-content-between" onclick="prevStep(1)">
                                                        <i class="fa fa-chevron-left fs-6 m-0 p-0" aria-hidden="true"></i>
                                                        <span>Voltar</span>
                                                    </button>
                                                </div>
                                                <div class="col-md-6">
                                                    <button type="button" class="btn btn-sm rounded-2 bg-gradient-info w-100 mt-4 mb-0 d-flex align-items-center justify-content-between" onclick="nextStep(3);">
                                                        <span>Avançar</span>
                                                        <i class="fa fa-chevron-right fs-6 m-0 p-0" aria-hidden="true"></i>
                                                        <div class="spinner-border spinner-border-sm text-light d-none" role="status">
                                                            <span class="visually-hidden">Loading...</span>
                                                        </div>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Step 3 -->
                                        <div class="step" id="step3" style="display: none;">
                                            <div class="row space-y-4">
                                                <div class="col-md-4">
                                                    <div class="input-group input-group-outline mb-3" data-input-name='cep'>
                                                        <label class="form-label">CEP</label>
                                                        <input type="text" class="form-control" name="cep" id="cep" inputmode="numeric" maxlength="8" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-8">
                                                    <div class="input-group input-group-outline mb-3" data-input-name='logradouro'>
                                                        <label class="form-label">Logradouro</label>
                                                        <input type="text" class="form-control" name="logradouro" id="logradouro" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row space-y-4">
                                                <div class="col-md-4">
                                                    <div class="input-group input-group-outline mb-3" data-input-name='numero'>
                                                        <label class="form-label">Número</label>
                                                        <input type="text" class="form-control" name="numero" id="numero" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-8">
                                                    <div class="input-group input-group-outline mb-3" data-input-name='bairro'>
                                                        <label class="form-label">Bairro</label>
                                                        <input type="text" class="form-control" name="bairro" id="bairro" required>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="input-group input-group-outline mb-3" data-input-name='cidade'>
                                                        <label class="form-label">Cidade</label>
                                                        <input type="text" class="form-control" name="cidade" id="cidade" required>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="input-group input-group-outline mb-3" data-input-name='estado'>
                                                        <label class="form-label">Estado</label>
                                                        <select class="form-control" name="estado" id="estado" required>
                                                            @foreach ($estados as $sigla => $estado)
                                                                <option value="{{ $sigla }}">{{ $estado }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row space-y-4">
                                                <div class="col-md-6">
                                                    <button type="button" class="btn btn-sm rounded-2 bg-outline-primary border border-1 w-100 mt-4 mb-0 d-flex align-items-center justify-content-between" onclick="prevStep(2)">
                                                        <i class="fa fa-chevron-left fs-6 m-0 p-0" aria-hidden="true"></i>
                                                        <span>Voltar</span>
                                                    </button>
                                                </div>
                                                <div class="col-md-6">
                                                    <button type="submit" class="btn btn-sm rounded-2 bg-gradient-success w-100 mt-4 mb-0">
                                                        <span class="button-text d-flex align-items-center justify-content-between">
                                                            <span>Finalizar</span>
                                                            <i class="fa fa-check fs-6 m-0 p-0" aria-hidden="true"></i>
                                                        </span>
                                                        <div class="spinner-border spinner-border-sm text-light d-none" role="status">
                                                            <span class="visually-hidden">Loading...</span>
                                                        </div>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                    {{-- Step 4 --}}
                                    @if (!$plano->gratuito)
                                        <div class="step" id="step4" style="display: none;">
                                            <div class="plan-info">
                                                <p><span class="font-weight-bolder">Plano:</span> {{ $plano->nome }}</p>
                                                <p><span class="font-weight-bolder">Valor:</span> R$ {{ number_format($plano->valor, 2, ',', '.') }}</p>
                                                <p class="d-flex align-items-center justify-content-between">
                                                    <span class="font-weight-bolder">Chave pix:</span> <span class="badge badge-sm border border-1 text-secondary w-70 overflow-x-scroll" onclick="copyToClipboard(this);" id="chave-pix"></span> <i class="fa fa-clipboard" onclick="copyToClipboard(document.getElementById('chave-pix'));" aria-hidden="true"></i>
                                                </p>
                                                <p><span class="font-weight-bolder">Status: </span> <span id="status-payment">Aguardando pagamento...</span></p>
                                            </div>
                                            <div id="countdown"></div>
                                            <div id="qr-code-container" class="my-2 d-flex align-items-center justify-content-center" style="text-align: center;">
                                                <img id="qr-code" alt="QR Code" style="width: 150px">
                                            </div>
                                        </div>
                                    @endif
                                </div>

                                <div class="card-footer text-center pt-0 px-lg-2 px-1">
                                    <p class="mt-2 mb-2 text-sm text-center">
                                        Já possui uma conta?
                                        <a href="{{ route('login') }}" class="text-info text-gradient font-weight-normal">Clique Aqui</a>
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Image moved to the right -->
                        <div class="col-6 d-lg-flex d-none h-100 my-auto ps-0 position-absolute top-0 end-0 text-center justify-content-center flex-column">
                            <div class="position-relative bg-gradient-primary h-100 m-3 px-7 border-radius-lg d-flex flex-column justify-content-center" style="background-image: url('../../../assets/img/illustrations/illustration-signup.jpg'); background-size: cover;">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <script>
        function toggleLoading(isLoading) {
            const spinner = document.querySelector('.spinner-border');
            spinner.style.display = isLoading ? '' : 'none';

            const buttons = document.querySelectorAll('button');
            buttons.forEach(button => {
                button.disabled = isLoading;
            });

            const buttonText = document.querySelector('.button-text');
            buttonText.style.display = isLoading ? 'none' : '';
        }

        // Fetch para consultar dados de CNPJ via API
        async function consultarCNPJ() {
            const cnpj = document.getElementById('documento').value.replace(/\D/g, '');
            let inputs = ['nome', 'nomefantasia', 'cidade', 'estado', 'logradouro', 'numero', 'bairro', 'cep'];
            let datas = ['razao_social', 'nome_fantasia', 'municipio', 'uf', 'logradouro', 'numero', 'bairro', 'cep'];

            toggleLoading(true);

            fetch(`https://brasilapi.com.br/api/cnpj/v1/${cnpj}`)
                .then(response => response.json())
                .then(data => {
                    inputs.forEach((input, index) => {
                        document.getElementById(input).value = data[datas[index]] || '';
                        if (input === 'cep' && data.cep) {
                            document.getElementById('cep').value = formatCEP(data.cep) || '';
                        }

                        if (input === 'logradouro' && data.logradouro) {
                            document.getElementById('logradouro').value = data.descricao_tipo_de_logradouro + ' ' + data.logradouro || '';
                        }

                        if (data[datas[index]]) {
                            document.querySelector(`[data-input-name="${input}"]`).classList.add('focused', 'is-focused');
                        }
                    });
                })
                .catch(error => {
                    console.error('Erro ao buscar o CNPJ:', error);
                })
                .finally(() => {
                    toggleLoading(false);

                    // Chamar a próxima etapa se necessário
                    nextStep(2);
                })
        }

        let currentStep = 1;
        const plano = @json($plano);
        const totalSteps = plano.gratuito == true ? 3 : 4;

        function updateProgressBar() {
            const progress = (currentStep / totalSteps) * 100;
            document.getElementById('progress-bar').style.width = `${progress}%`;
        }

        function showStep(step) {
            document.querySelectorAll('.step').forEach(el => el.style.display = 'none');
            document.getElementById(`step${step}`).style.display = 'block';
        }

        function nextStep(step) {
            if (validateStep(currentStep)) {
                currentStep = step;
                showStep(currentStep);
                updateProgressBar();
            }
        }

        function prevStep(step) {
            currentStep = step;
            showStep(currentStep);
            updateProgressBar();
        }

        function validateStep(step) {
            const inputs = document.querySelectorAll(`#step${step} input[required]`);
            const selects = document.querySelectorAll(`#step${step} select[required]`);
            let isValid = true;

            inputs.forEach(input => {
                if (!input.value) {
                    isValid = false;
                    input.classList.add('is-invalid');
                    // Adicionando o foco
                    input.closest('.input-group').classList.remove('focused', 'is-focused');
                } else {
                    input.classList.remove('is-invalid');
                    input.closest('.input-group').classList.add('focused', 'is-focused');
                }
            });

            selects.forEach(select => {
                if (!select.value) {
                    isValid = false;
                    select.classList.add('is-invalid');
                } else {
                    select.classList.remove('is-invalid');
                }
            });

            return isValid;
        }

        function formatCEP(cep) {
            return cep.replace(/(\d{2})(\d{3})(\d{3})/, "$1.$2-$3");
        }

        let countdownTimeout; // Variável global para armazenar o identificador do timeout

        // Função contador
        // Formato de valor: "2024-10-03T19:11:18Z"
        function countdown(dateTimeStart, dateTimeEnd, textCountdown = null, reset = false) {
            const countdownElement = document.getElementById('countdown');

            // Limpa o timeout anterior, se existir
            if (countdownTimeout) {
                clearTimeout(countdownTimeout);
            }

            // Lógica de verificação para quando `dateTimeEnd` for nulo ou indefinido
            if (!dateTimeEnd || reset) {
                countdownElement.innerHTML = `${textCountdown} 0h 0m 0s`;
                return;
            }

            const dateEnd = new Date(dateTimeEnd);

            const updateCountdownDisplay = () => {
                const now = new Date();
                const diff = dateEnd.getTime() - now.getTime();

                if (diff <= 0) {
                    countdownElement.innerHTML = `${textCountdown} 0h 0m 0s`;
                    return;
                }

                const days = Math.floor(diff / (1000 * 60 * 60 * 24));
                const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((diff % (1000 * 60)) / 1000);

                countdownElement.innerHTML = `${textCountdown ? textCountdown + ' ' : ''} ${days ? days + 'd ' : ''} ${hours ? hours + 'h ' : ''} ${minutes ? minutes + 'm ' : ''} ${seconds ? seconds + 's ' : ''}`;

                // Chama novamente a função após 1 segundo
                countdownTimeout = setTimeout(updateCountdownDisplay, 1000);
            };

            // Inicia a atualização
            updateCountdownDisplay();
        }

        function copyToClipboard(element) {
            navigator.clipboard.writeText(element.textContent);
            alert('Copiado para a area de transferência');
        }

        function formatDocument(value) {
            // Remove todos os caracteres que não são dígitos
            value = value.replace(/\D/g, '');

            // Aplica a máscara conforme o usuário digita
            value = value.replace(/^(\d{2})(\d)/, '$1.$2');
            value = value.replace(/^(\d{2})\.(\d{3})(\d)/, '$1.$2.$3');
            value = value.replace(/\.(\d{3})(\d{4})(\d)/, '.$1/$2-$3');

            return value;
        }

        document.getElementById('documento').addEventListener('input', function() {
            this.value = formatDocument(this.value);
        });

        function formatCelular(celular) {
            // Remove todos os caracteres que não são dígitos
            celular = celular.replace(/\D/g, '');

            // Aplica a máscara conforme o usuário digita: (00) 0 0000-0000
            celular = celular.replace(/^(\d{2})(\d)/, '($1) $2'); // Adiciona o DDD e o primeiro dígito do número
            celular = celular.replace(/(\d{1})(\d{4})(\d{4})/, '$1 $2-$3'); // Formata o restante do número

            return celular;
        }

        document.getElementById('celular').addEventListener('input', function() {
            this.value = formatCelular(this.value);
        });

        document.getElementById('cep').addEventListener('change', function() {
            document.getElementById('cep').value = formatCEP(this.value);
        })

        let idtenant = null;
        let idrepresentante = "{{ Request::get('idpessoa') ? Request::get('idpessoa') : '' }}";

        document.getElementById('multi-step-form').addEventListener('submit', async function (e) {

            e.preventDefault(); // Impede o comportamento padrão do envio do formulário

            if (validateStep(currentStep)) {
                if (currentStep === 3) {
                    toggleLoading(true);

                    fetch(`{{ route('cadastro.store', ['plano' => $plano]) }}`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({
                            idrepresentante: document.getElementById('idrepresentante').value,
                            nomefantasia: document.getElementById('nomefantasia').value,
                            documento: document.getElementById('documento').value,
                            celular: document.getElementById('celular').value,
                            nome: document.getElementById('nome').value,
                            email: document.getElementById('email').value,
                            password: document.getElementById('senha').value,
                            cep: document.getElementById('cep').value,
                            logradouro: document.getElementById('logradouro').value,
                            bairro: document.getElementById('bairro').value,
                            cidade: document.getElementById('cidade').value,
                            estado: document.getElementById('estado').value,
                            numero: document.getElementById('numero').value
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (plano.gratuito) {
                            fetch('{{ route('login') }}', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                                },
                                body: JSON.stringify({
                                    login: document.getElementById('email').value,
                                    password: document.getElementById('senha').value
                                })
                            })
                            .then(response => {
                                // Redireciona para o dashboard após login bem-sucedido
                                window.location.href = "{{ route('dashboard.financeiro') }}";
                            })
                            .catch(error => {
                                console.error('Erro ao realizar login:', error);
                            });
                        } else if (data.nf) {
                            idtenant = data.idtenant;

                            // Altera o titulo do card
                            document.getElementById('card-title').textContent = 'Aguardando Pagamento';
                            // Altera o sub-titulo do card
                            document.getElementById('card-subtitle').textContent = 'Bem-vindo de volta! Após confirmação do pagamento, você será redirecionado para a página de acesso.';

                            // Atualiza o valor da chave Pix
                            document.getElementById('chave-pix').textContent = data.nf.chavepix;
                            document.getElementById('chave-pix').style.display = 'block';

                            // Inicia o countdown
                            countdown(data.nf.dataemissao, data.nf.datavencimento, 'Prazo:', false);

                            document.getElementById('qr-code').src = data.nf.qrcodeurl;
                        } else {
                            if (data.data.charges[0].last_transaction.qr_code_url) {
                                // Armazena o ID do tenant
                                idtenant = data.idtenant;

                                // Altera o titulo do card
                                document.getElementById('card-title').textContent = 'Aguardando Pagamento';
                                // Altera o sub-titulo do card
                                document.getElementById('card-subtitle').textContent = 'Após confirmação do pagamento, você será redirecionado para a página de acesso.';

                                // Atualiza o valor da chave Pix
                                document.getElementById('chave-pix').textContent = data.data.charges[0].last_transaction.qr_code;
                                document.getElementById('chave-pix').style.display = 'block';

                                // Inicia o countdown
                                countdown(data.data.charges[0].last_transaction.created_at, data.data.charges[0].last_transaction.expires_at, 'Prazo:', false);

                                // Cria um elemento img com o qr_code_url no src
                                document.getElementById('qr-code').src = data.data.charges[0].last_transaction.qr_code_url;
                            }
                        }
                    })
                    .catch(error => {
                        console.error('Erro ao enviar os dados:', error);
                    })
                    .finally(() => {
                        toggleLoading(false);

                        if ("{{ !$plano->gratuito == true }}") {
                            nextStep(4);
                        }
                    })
                }
            }
        });

        // Inicialização
        updateProgressBar();

        // Função para verificar o status do tenant
        function checkTenantStatus() {
            if (idtenant) {
                fetch(`/cadastro/${idtenant}/status`, {
                    method: 'GET',
                    headers: {
                        'Content-Type': 'application/json',
                    }
                })
                .then(response => {
                    if (!response.ok) {
                        console.error('Erro na resposta: ' + response.status);  // Verifica o status da resposta
                    }
                    return response.text();
                })
                .then(text => {
                    // Remove aspas do texto
                    const cleanedText = text.replace(/"/g, '');

                    // Verifica se o status retornado é ATIVO
                    if (cleanedText === 'ATIVO') {
                        // Limpa o container de qr code
                        document.getElementById('qr-code-container').innerHTML = 'Pagamento concluído';

                        // Altera o titulo do card
                        document.getElementById('card-title').textContent = 'Redirecionando...';
                        // Altera o sub-titulo do card
                        document.getElementById('card-subtitle').textContent = 'Agora você pode acessar o sistema';

                        document.getElementById('status-payment').textContent = 'Pagamento concluído';

                        // Resetando o countdown
                        countdown(null, null, '', true);

                        // Inicia o countdown de 5 segundos
                        countdown(new Date(), new Date(new Date().getTime() + 5 * 1000), 'Redirecionando em:', false);


                        // Pode rodar a função imediatamente no carregamento da página
                        setTimeout(() => {
                            fetch('{{ route('login') }}', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                                },
                                body: JSON.stringify({
                                    login: document.getElementById('email').value,
                                    password: document.getElementById('senha').value
                                })
                            })
                            .then(response => {
                                // Redireciona para o dashboard após login bem-sucedido
                                window.location.href = "{{ route('dashboard.financeiro') }}";
                            })
                            .catch(error => {
                                console.error('Erro ao realizar login:', error);
                            });
                        }, 5000);
                    }
                })
                .catch(error => {
                    console.error('Erro ao verificar o status:', error);
                });
            }
        }

        // Executa a verificação a cada 30 segundos
        setInterval(checkTenantStatus, 30000);

        // Pode também rodar a função imediatamente no carregamento da página
        checkTenantStatus();
    </script>
</x-layout>
