<div id="filterModal" class="modal fade" tabindex="-1" aria-labelledby="filterModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="filterModalLabel">Filtros</h5>
                <button class="btn btn-sm m-0 clearAll" style="text-transform: none;" id="clearAll">
                    Apagar tudo
                </button>
            </div>
            <div class="modal-body">
                <div>
                    <form action="{{ isset($route) ? $route : '' }}" id="filtersForm">
                        <div class="d-flex flex-column {{ isMobile() ? 'flex-wrap' : '' }}" id="filterGroups"></div>
                    </form>
                </div>
                <button type="button" class="btn border btn-sm m-0 shadow-none addFilter" style="text-transform: none;" id="addFilterGroup">
                    <i class="fa fa-plus"></i> Adicionar filtro
                </button>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn close-filters btn-sm m-0 me-3 shadow-none" data-bs-dismiss="modal">Fechar</button>
                <button type="submit" class="btn btn-dark btn-sm m-0 shadow-sm" id="submitFilters">Salvar</button>
            </div>
        </div>
    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.min.js" integrity="sha512-IOebNkvA/HZjMM7MxL0NYeLYEalloZ8ckak+NDtOViP7oiYzG5vn6WVXyrJDiJPhl4yRdmNAG49iuLmhkUdVsQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
$(document).ready(function() {
    const filters = @json($filters);
    let filterGroups = @json($appliedFilters ?? []);

    if (filterGroups.length === 0) {
        filterGroups = [{
            id: Date.now(),
            prefix: 'ONDE',
            showPrefix: true,
            canToggle: false,
            filters: [{ id: Date.now(), field: '', operator: '=', value: '', inputType: 'text', options: [], prefix: 'ONDE', canToggle: false, required: false, datePickerValue: '' }]
        }];
    }

    function renderFilterGroups() {
        $('#filterGroups').empty();
        if (!filters || filters.length === 0) {
            console.error('No filters available');
            return;
        }
        filterGroups.forEach((group, groupIndex) => {
            const groupHtml = `
                <div class="col-md-12 d-flex {{ isMobile() ? 'flex-wrap gap-2' : '' }} align-items-center mb-3" data-group-id="${group.id}">
                    <div class="col-md-2 prefix-column">
                        ${group.showPrefix ? `
                            <div class="d-flex align-items-center" style="height: 38px;">
                                <input type="hidden" name="group-prefix[]" value="${group.prefix}" />
                                <button
                                    type="button"
                                    class="btn btn-sm border rounded-3 shadow-none m-0 d-flex align-items-center justify-content-between group-prefix ${group.canToggle ? 'dropdown-toggle' : ''}"
                                    data-group-id="${group.id}"
                                    ${!group.canToggle ? 'disabled' : ''}
                                >
                                    ${group.prefix}
                                </button>
                            </div>
                        ` : ''}
                    </div>
                    <div class="col-md-10 border rounded-3 p-2">
                        <div class="filters-container d-flex flex-wrap gap-1"></div>
                        <button type="button" class="btn btn-sm m-0 add-filter-group" style="text-transform: none" data-group-id="${group.id}">
                            + Adicionar filtro agrupado
                        </button>
                    </div>
                    ${(filterGroups.indexOf(group) > 0) ? `
                        <button type="button" class="btn btn-sm text-dark m-0 remove-group" data-group-id="${group.id}">
                            <i class="fa fa-trash" style="font-size: .7rem"></i>
                        </button>
                    ` : ''}
                </div>
            `;
            $('#filterGroups').append(groupHtml);
            renderFilters(group);
        });
    }

    function renderFilters(group) {
        const $filtersContainer = $(`.col-md-12[data-group-id="${group.id}"] .filters-container`);
        $filtersContainer.empty();
        group.filters.forEach((filter, filterIndex) => {
            const filterHtml = `
                <div class="d-flex {{ isMobile() ? 'flex-wrap gap-2' : '' }} align-items-center justify-content-between mb-2 col-md-12 col-sm-12 col-12" data-filter-id="${filter.id}">
                    ${(filterIndex >= 0 || filterGroups.indexOf(group) > 0) ? `
                        <input type="hidden" name="filter-prefix[]" value="${filter.prefix}" />
                        <button
                            type="button"
                            class="col-auto btn btn-sm border rounded-3 shadow-none m-0 d-flex align-items-center justify-content-between filter-prefix ${filter.canToggle ? 'dropdown-toggle' : ''}"
                            style="width: 70px;"
                            data-group-id="${group.id}"
                            data-filter-id="${filter.id}"
                            ${!filter.canToggle ? 'disabled' : ''}
                        >
                            ${filter.prefix}
                        </button>
                    ` : '<div style="width: 70px;"></div>'}
                    <div class="col-md-10 d-flex {{ isMobile() ? 'flex-wrap' : '' }} align-items-center justify-content-end gap-2">
                        <div class="col-md-4 col-sm-4 col-12">
                            <select class="form-select form-select-sm field" id="field-${filter.id}" name="campos[]" data-filter-id="${filter.id}" data-group-id="${group.id}" ${filter.required ? 'required' : ''}>
                                <option value="" disabled>Selecionar filtro</option>
                                ${filters.map(f => `<option value="${f.value}" ${filter.field === f.value ? 'selected' : ''}>${f.label}</option>`).join('')}
                            </select>
                        </div>
                        <div class="col-md-3 col-sm-3 col-12">
                            <select class="form-select form-select-sm operator custom-select" id="operator-${filter.id}" name="operadores[]" data-filter-id="${filter.id}" data-group-id="${group.id}">
                                <option value="=" ${filter.operator === '=' ? 'selected' : ''}>Igual a</option>
                                <option value="<" ${filter.operator === '<' ? 'selected' : ''}>Menor que</option>
                                <option value=">" ${filter.operator === '>' ? 'selected' : ''}>Maior que</option>
                                <option value="like" ${filter.operator === 'like' ? 'selected' : ''}>Contém</option>
                                <option value="<>" ${filter.operator === '<>' ? 'selected' : ''}>Diferente</option>
                            </select>
                        </div>
                        <div class="col-md-3 col-sm-3 col-12">
                            ${getInputField(filter, group.id)}
                        </div>
                        ${(filterIndex > 0 || filterGroups.indexOf(group) > 0) ? `
                            <button type="button" class="col-md-1 col-sm-1 col-1 btn btn-sm text-dark m-0 remove-filter" data-group-id="${group.id}" data-filter-id="${filter.id}" ${filter.required ? 'disabled' : ''}>
                                <i class="fa fa-trash" style="font-size: .7rem"></i>
                            </button>
                        ` : ''}
                    </div>
                </div>
            `;
            $filtersContainer.append(filterHtml);

            // Set date values if present
            if (filter.inputType === 'date' && filter.value) {
                const [startDate, endDate] = filter.value.split(',');
                $(`#startDate-${filter.id}`).val(startDate);
                $(`#endDate-${filter.id}`).val(endDate);
                if (filter.datePickerValue) {
                    $(`#datePicker-${filter.id}`).val(filter.datePickerValue);
                    if (filter.datePickerValue === 'custom') {
                        $(`.date-range-inputs[data-filter-id="${filter.id}"]`).show();
                    }
                } else {
                    const datePickerValue = getDatePickerValueFromDates(startDate, endDate);
                    $(`#datePicker-${filter.id}`).val(datePickerValue);
                    filter.datePickerValue = datePickerValue;
                    if (datePickerValue !== 'custom') {
                        $(`.date-range-inputs[data-filter-id="${filter.id}"]`).hide();
                    }
                }
            }
        });
        initSelectize(group.filters, group.id);
    }

    function getInputField(filter, groupId) {
        const id = filter.id;
        if (filter.inputType === 'select') {
            let optionsHtml = '<option value="">Selecione...</option>';
            if (filter.options && Array.isArray(filter.options)) {
                const valueField = filter.valueField || 'id';
                const textFields = Array.isArray(filter.textField) ? filter.textField : [filter.textField || 'name'];
                optionsHtml += filter.options.map(option => {
                    const optionText = textFields.map(field => option[field]).filter(Boolean).join(' - ');
                    return `<option value="${option[valueField]}" ${filter.value == option[valueField] ? 'selected' : ''}>${optionText}</option>`;
                }).join('');
            }

            return `
                <div class="custom-select-container">
                    <select class="form-select form-select-sm custom-select" id="value-select-${id}" name="valores[]" data-filter-id="${id}" data-group-id="${groupId}">
                        ${optionsHtml}
                    </select>
                </div>`;
        } else if (filter.inputType === 'date') {
            return `
                <div class="date-picker-container col-md-12 col-sm-12 col-12">
                    <select class="form-select form-select-sm date-picker-select" id="datePicker-${id}" name="valores[]" data-filter-id="${id}" data-group-id="${groupId}">
                        <option value="">Selecione</option>
                        <option value="today">Hoje</option>
                        <option value="yesterday">Ontem</option>
                        <option value="last7days">Últimos 7 dias</option>
                        <option value="lastweek">Última semana</option>
                        <option value="thisweek">Esta semana</option>
                        <option value="lastmonth">Mês passado</option>
                        <option value="thismonth">Este mês</option>
                        <option value="lastyear">Ano passado</option>
                        <option value="custom">Período</option>
                    </select>
                    <div class="date-range-inputs mt-2" data-filter-id="${id}" style="display: none;">
                        <div class="input-group mb-2">
                            <input type="date" class="form-control form-control-sm border rounded-2" id="startDate-${id}" name="date-range[]" data-filter-id="${id}" data-group-id="${groupId}">
                        </div>
                        <div class="input-group">
                            <input type="date" class="form-control form-control-sm border rounded-2" id="endDate-${id}" name="date-range[]" data-filter-id="${id}" data-group-id="${groupId}">
                        </div>
                    </div>
                </div>
            `;
        }

        return `
            <input type="${filter.inputType}" class="form-control form-control-sm border rounded-3 ps-2"
                   id="value-${id}" name="valores[]" value="${filter.value}"
                   data-filter-id="${id}" data-group-id="${groupId}"
                   placeholder="Digite um valor" />`;
    }

    function addFilterGroup() {
        const newGroupId = Date.now();
        const groups = filterGroups;
        filterGroups.push({
            id: newGroupId,
            prefix: groups.length > 1 && groups[0].prefix === 'ONDE' && groups[1].prefix === 'E' ? 'E' : 'OU',
            showPrefix: true,
            canToggle: filterGroups.length === 1,
            filters: [{
                id: Date.now(),
                field: '',
                operator: '=',
                value: '',
                inputType: 'text',
                options: [],
                prefix: 'ONDE',
                canToggle: false,
                required: false,
                datePickerValue: ''
            }]
        });
        renderFilterGroups();
        saveFiltersToCache();
    }

    function addFilter(groupId) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const newFilterId = Date.now();
            const newFilterIndex = group.filters.length;
            group.filters.push({
                id: newFilterId,
                field: '',
                operator: '=',
                value: '',
                inputType: 'text',
                options: [],
                prefix: group.filters.length > 1 && group.filters[0].prefix === 'ONDE' && group.filters[1].prefix === 'E' ? 'E' : 'OU',
                canToggle: newFilterIndex === 1,
                required: false,
                datePickerValue: ''
            });
            renderFilters(group);
            saveFiltersToCache();
        }
    }

    function removeFilter(groupId, filterId) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            group.filters = group.filters.filter(f => f.id !== parseInt(filterId));
            renderFilters(group);
            saveFiltersToCache();
        }
    }

    function removeFilterGroup(groupId) {
        filterGroups = filterGroups.filter(g => g.id !== parseInt(groupId));
        renderFilterGroups();
        saveFiltersToCache();
    }

    function clearAll() {
        filterGroups = [{
            id: Date.now(),
            prefix: 'ONDE',
            showPrefix: true,
            canToggle: false,
            filters: [{ id: Date.now(), field: '', operator: '=', value: '', inputType: 'text', options: [], prefix: 'ONDE', canToggle: false, required: false, datePickerValue: '' }]
        }];
        renderFilterGroups();
        saveFiltersToCache();
    }

    function toggleGroupPrefix(groupId) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group && group.canToggle) {
            const newPrefix = group.prefix === 'OU' ? 'E' : 'OU';
            group.prefix = newPrefix;
            const groupsAfterThis = filterGroups.slice(filterGroups.indexOf(group) + 1);
            groupsAfterThis.forEach(g => g.prefix = newPrefix);
            renderFilterGroups();
            saveFiltersToCache();
        }
    }

    function toggleFilterPrefix(groupId, filterId) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        const filter = group?.filters.find(f => f.id === parseInt(filterId));
        if (filter && filter.canToggle) {
            const newPrefix = filter.prefix === 'OU' ? 'E' : 'OU';
            const filtersAfterThis = group.filters.slice(group.filters.indexOf(filter) + 1);
            filtersAfterThis.forEach(f => f.prefix = newPrefix);
            filter.prefix = newPrefix;
            renderFilters(group);
            saveFiltersToCache();
        }
    }

    function updateFilterType(groupId, filterId, selectedValue) {
        const selectedFilter = filters.find(f => f.value === selectedValue);
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const filter = group.filters.find(f => f.id === parseInt(filterId));
            if (filter && selectedFilter) {
                const oldValue = filter.value;
                const oldInputType = filter.inputType;
                const oldDatePickerValue = filter.datePickerValue;
                filter.field = selectedValue;
                filter.inputType = selectedFilter.inputType;
                filter.options = selectedFilter.options || [];
                filter.required = selectedFilter.required || false;
                filter.operator = filter.operator || '=';
                filter.valueField = selectedFilter.valueField;
                filter.textField = selectedFilter.textField;

                // Preserve values when switching between fields
                if (oldInputType === filter.inputType) {
                    filter.value = oldValue;
                    if (filter.inputType === 'date') {
                        filter.datePickerValue = oldDatePickerValue;
                    }
                } else if (filter.inputType === 'select' && oldValue && filter.options.some(opt => opt[filter.valueField || 'id'] == oldValue)) {
                    filter.value = oldValue;
                } else if (filter.inputType === 'date' && oldValue) {
                    filter.value = oldValue;
                    filter.datePickerValue = oldDatePickerValue || '';
                } else {
                    filter.value = '';
                    filter.datePickerValue = '';
                }

                renderFilters(group);
                saveFiltersToCache();
            }
        }
    }

    function initSelectize(filters, groupId) {
        if (!filters || !Array.isArray(filters)) {
            console.error('Invalid filters array');
            return;
        }
        filters.forEach(filter => {
            const selectizeFields = [
                `field-${filter.id}`,
                `operator-${filter.id}`,
                `value-select-${filter.id}`,
                `datePicker-${filter.id}`,
            ];
            selectizeFields.forEach(fieldId => {
                const $select = $(`#${fieldId}[data-group-id="${groupId}"]`);
                if ($select.length && !$select[0].selectize) {
                    $select.selectize({
                        onChange: function(value) {
                            const filterId = parseInt(this.$input[0].id.split('-')[1]);
                            const filterType = this.$input[0].id.split('-')[0];
                            const groupId = this.$input.data('group-id');
                            if (filterType === 'field') {
                                updateFilterType(groupId, filterId, value);
                            } else if (filterType === 'operator') {
                                updateFilterOperator(groupId, filterId, value);
                            } else if (filterType === 'datePicker') {
                                handleDatePickerChange(groupId, filterId, value);
                            } else {
                                updateFilterValue(groupId, filterId, value);
                            }
                            saveFiltersToCache();
                        }
                    });
                }
            });
        });
    }

    function updateFilterValue(groupId, filterId, value) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const filter = group.filters.find(f => f.id === parseInt(filterId));
            if (filter) {
                filter.value = value;
                if (filter.inputType === 'date') {
                    const $dateRangeInputs = $(`.date-range-inputs[data-filter-id="${filterId}"]`);
                    const $datePicker = $(`#datePicker-${filterId}`);
                    if (value.includes(',') && filter.datePickerValue === 'custom') {
                        const [startDate, endDate] = value.split(',');
                        $(`#startDate-${filterId}`).val(startDate);
                        $(`#endDate-${filterId}`).val(endDate);
                        $dateRangeInputs.show();
                    } else {
                        $dateRangeInputs.hide();
                    }
                    $datePicker.val(filter.datePickerValue);
                }
                saveFiltersToCache();
            }
        }
    }

    function updateFilterOperator(groupId, filterId, operator) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const filter = group.filters.find(f => f.id === parseInt(filterId));
            if (filter) {
                filter.operator = operator;
                saveFiltersToCache();
            }
        }
    }

    function handleDatePickerChange(groupId, filterId, value) {
        const group = filterGroups.find(g => g.id === parseInt(groupId));
        if (group) {
            const filter = group.filters.find(f => f.id === parseInt(filterId));
            if (filter) {
                const $dateRangeInputs = $(`.date-range-inputs[data-filter-id="${filterId}"]`);
                const $datePicker = $(`#datePicker-${filterId}`);

                filter.datePickerValue = value;

                if (value === 'custom') {
                    $dateRangeInputs.show();
                    const startDate = $(`#startDate-${filterId}`).val();
                    const endDate = $(`#endDate-${filterId}`).val();
                    if (startDate && endDate) {
                        filter.value = `${startDate},${endDate}`;
                    } else {
                        filter.value = '';
                    }
                } else {
                    $dateRangeInputs.hide();
                    const dateRange = setDateRange(value);
                    filter.value = dateRange;

                    // Set the date range input values
                    const [startDate, endDate] = dateRange.split(',');
                    $(`#startDate-${filterId}`).val(startDate);
                    $(`#endDate-${filterId}`).val(endDate);
                }

                $datePicker.val(value);
                saveFiltersToCache();
            }
        }
    }

    function setDateRange(value) {
        const today = new Date();
        let startDate = new Date(today);
        let endDate = new Date(today);

        switch(value) {
            case 'today':
                break;
            case 'yesterday':
                startDate.setDate(today.getDate() - 1);
                endDate = new Date(startDate);
                break;
            case 'last7days':
                startDate.setDate(today.getDate() - 6);
                break;
            case 'lastweek':
                startDate = new Date(today.setDate(today.getDate() - today.getDay() - 7));
                endDate = new Date(startDate);
                endDate.setDate(startDate.getDate() + 6);
                break;
            case 'thisweek':
                startDate = new Date(today.setDate(today.getDate() - today.getDay()));
                endDate = new Date(startDate);
                endDate.setDate(startDate.getDate() + 6);
                break;
            case 'lastmonth':
                startDate = new Date(today.getFullYear(), today.getMonth() - 1, 1);
                endDate = new Date(today.getFullYear(), today.getMonth(), 0);
                break;
            case 'thismonth':
                startDate = new Date(today.getFullYear(), today.getMonth(), 1);
                endDate = new Date(today.getFullYear(), today.getMonth() + 1, 0);
                break;
            case 'lastyear':
                startDate = new Date(today.getFullYear() - 1, 0, 1);
                endDate = new Date(today.getFullYear() - 1, 11, 31);
                break;
            default:
                return '';
        }

        return `${formatDate(startDate)},${formatDate(endDate)}`;
    }

    function formatDate(date) {
        return date.toISOString().split('T')[0];
    }

    function getDatePickerValueFromDates(startDate, endDate) {
        const today = new Date();
        const start = new Date(startDate);
        const end = new Date(endDate);

        if (start.toDateString() === end.toDateString()) {
            if (start.toDateString() === today.toDateString()) {
                return 'today';
            }
            if (start.toDateString() === new Date(today.setDate(today.getDate() - 1)).toDateString()) {
                return 'yesterday';
            }
        }

        // Check for other predefined ranges
        const ranges = {
            'last7days': 7,
            'lastweek': 7,
            'thisweek': 7,
            'lastmonth': 30,
            'thismonth': 30,
            'lastyear': 365
        };

        for (const [range, days] of Object.entries(ranges)) {
            const testRange = setDateRange(range).split(',');
            if (startDate === testRange[0] && endDate === testRange[1]) {
                return range;
            }
        }

        return 'custom';
    }

    function submitForm() {
        const $form = $('#filtersForm');
        const formData = new FormData($form[0]);

        const processedFilterGroups = filterGroups.map(group => ({
            prefix: group.prefix,
            filters: group.filters.filter(filter => filter.field && filter.value).map(filter => ({
                field: filter.field,
                operator: filter.operator,
                value: filter.value,
                prefix: filter.prefix
            }))
        })).filter(group => group.filters.length > 0);

        formData.append('filterGroups', JSON.stringify(processedFilterGroups));

        // Save filters to cache before submitting
        saveFiltersToCache();

        // Submit the form
        $form.submit();
    }

    // Funções de cache
    function saveFiltersToCache() {
        localStorage.setItem('cachedFilters', JSON.stringify({
            filterGroups,
            pageUrl: window.location.href
        }));
    }

    function loadFiltersFromCache() {
        const cachedFilters = JSON.parse(localStorage.getItem('cachedFilters'));
        if (!cachedFilters) return;

        const isSamePage = window.location.href === cachedFilters.pageUrl;
        const hasNoSearch = !window.location.search;

        if (hasNoSearch) {
            filterGroups = isSamePage ? cachedFilters.filterGroups : filterGroups;
        } else {
            filterGroups = cachedFilters.filterGroups;
        }

        renderFilterGroups();
        if (isSamePage && hasNoSearch) submitForm();

        const validFilters = filterGroups.reduce((count, group) =>
            count + group.filters.filter(filter => filter.field && filter.value).length, 0);

        $('#filter-count').text(`${validFilters > 0 ? validFilters : ''} filtros${validFilters > 1 ? 's' : ''}`);

        if (validFilters > 0) {
            $('#btn-filters').addClass('border');
            $('#filter-count').removeClass('d-none');
        }
    }

    // Event Listeners
    $('#addFilterGroup').on('click', addFilterGroup);
    $('#clearAll').on('click', clearAll);
    $('#filterGroups').on('click', '.add-filter-group', function() {
        addFilter($(this).data('group-id'));
    });
    $('#filterGroups').on('click', '.remove-filter', function() {
        removeFilter($(this).data('group-id'), $(this).data('filter-id'));
    });
    $('#filterGroups').on('click', '.remove-group', function() {
        removeFilterGroup($(this).data('group-id'));
    });
    $('#filterGroups').on('click', '.group-prefix', function() {
        toggleGroupPrefix($(this).data('group-id'));
    });
    $('#filterGroups').on('click', '.filter-prefix', function() {
        toggleFilterPrefix($(this).data('group-id'), $(this).data('filter-id'));
    });
    $('#filterGroups').on('change', '.field', function() {
        const groupId = $(this).closest('[data-group-id]').data('group-id');
        const filterId = $(this).data('filter-id');
        const selectedValue = $(this).val();
        const isRequired = $(this).find('option:selected').data('required') === true;

        updateFilterType(groupId, filterId, selectedValue);
        $(this).prop('required', isRequired);
        $(this).closest('.d-flex').find('.remove-filter').prop('disabled', isRequired);
    });
    $('#filterGroups').on('change', 'input[name="valores[]"]', function() {
        const groupId = $(this).closest('[data-group-id]').data('group-id');
        const filterId = $(this).closest('[data-filter-id]').data('filter-id');
        updateFilterValue(groupId, filterId, $(this).val());
    });
    $('#filterGroups').on('change', 'select[name="valores[]"]', function() {
        const groupId = $(this).closest('[data-group-id]').data('group-id');
        const filterId = $(this).data('filter-id');
        updateFilterValue(groupId, filterId, $(this).val());
    });
    $('#filterGroups').on('change', '.operator', function() {
        const groupId = $(this).closest('[data-group-id]').data('group-id');
        const filterId = $(this).data('filter-id');
        const selectedOperator = $(this).val();
        updateFilterOperator(groupId, filterId, selectedOperator);
    });
    $('#filterGroups').on('change', '.date-range-inputs input[type="date"]', function() {
        const filterId = $(this).data('filter-id');
        const groupId = $(this).data('group-id');
        const startDate = $(`#startDate-${filterId}`).val();
        const endDate = $(`#endDate-${filterId}`).val();
        if (startDate && endDate) {
            updateFilterValue(groupId, filterId, `${startDate},${endDate}`);
            $(`#datePicker-${filterId}`).val('custom');
        }
    });
    $('#filterGroups').on('change', '.date-picker-select', function() {
        const groupId = $(this).closest('[data-group-id]').data('group-id');
        const filterId = $(this).data('filter-id');
        const selectedValue = $(this).val();
        handleDatePickerChange(groupId, filterId, selectedValue);
    });
    $('#submitFilters').on('click', submitForm);

    // Initialize
    loadFiltersFromCache();
    renderFilterGroups();
});
</script>
